clear; %removes all variables from the workspace

D=950;
ke=2.4e8;
kv=1.2;
m1=0.01;
m2=0.3;
Fn = 1.2*(m1+m2)*9.81;
Ff = 0.5*Fn;


dT=0.001;
Length = 10000;
vt = zeros(Length,1);
v = zeros(Length,1);


vt = linspace(0,dT,Length); % Generate t for v
%v = 1000*(exp(vt/dT)-1); % Generate v(t)
v = 1000*(vt.^5/dT^5); % Generate v(t)
%v(Length/2:Length) = 100; % Generate v(t)

Tspan = [0 dT]; % Solve from t=1 to t=5
IC = [0 0 0 0]; % y(t=0) = 0
[T Y] = ode45(@(t,y) approde2(t,y,v,vt,D,ke,kv,m1,m2,Fn,Ff),Tspan,IC); % Solve ODE

F1= kv*interp1(vt,v,T);
F2= -ke*( Y(:,1)+Y(:,3) );
F3= -D*( Y(:,2)+Y(:,4) );
F4= kv*interp1(vt,v,T) -D*( Y(:,2)+Y(:,4) ) -ke*( Y(:,1)+Y(:,3) );

%plot(vt,v,'*',T, F1,'-');
%plot(T, F1,'-',T, F2,'-',T, F3,'-',T, F4,'-');
%plot(T, 1e8*Y(:,1),'-',T, 1e9*Y(:,3),'-',T, F4,'-');
plot(T, Y(:,1),'-',T, 100*Y(:,3),'-');
%plot(T, Y(:,3),'*');
title('Plot of y as a function of time');
xlabel('Time'); ylabel('Y(t)');